/*
 * Decompiled with CFR 0.152.
 */
package jp.or.kazusa.sakurai.util.kappatool.average;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jp.or.kazusa.sakurai.util.kappatool.average.classes.ElementData;
import jp.or.kazusa.sakurai.util.kappatool.average.classes.GeneData;
import jp.or.kazusa.sakurai.util.kappatool.average.logic.FileIO;
import jp.or.kazusa.sakurai.util.kappatool.average.logic.Validation;

public class KappaAverageMain
extends JFrame
implements Runnable {
    private static int Mode_DoProcess = 0;
    private static int Mode_DoIdFormat = 1;
    private File listFile = null;
    private File dataFile = null;
    private File saveFile = null;
    private File idFile = null;
    private int modeThread = 0;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JLabel jLabel = null;
    private JTextField jTextField = null;
    private JButton jButton = null;
    private JLabel jLabel1 = null;
    private JTextField jTextField1 = null;
    private JButton jButton1 = null;
    private JPanel jPanel2 = null;
    private JButton jButton2 = null;
    private JLabel jLabel_status = null;
    private JPanel jPanel3 = null;
    private JLabel jLabel2 = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanel4 = null;
    private JLabel jLabel3 = null;
    private JTextField jTextField2 = null;
    private JButton jButton3 = null;
    private JPanel jPanel5 = null;
    private JLabel jLabel4 = null;
    private JComboBox jComboBox = null;
    private JPanel jPanel6 = null;
    private JButton jButton4 = null;
    private JPanel jPanel7 = null;
    private JLabel jLabel5 = null;
    private JLabel jLabel6 = null;
    private JLabel jLabel7 = null;

    private void doThread(int mode) {
        this.modeThread = mode;
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        if (this.modeThread == Mode_DoProcess) {
            this.doProcess();
        } else if (this.modeThread == Mode_DoIdFormat) {
            this.doIdFormat();
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridwidth = 3;
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.gridy = 3;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints6.gridwidth = 3;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.insets = new Insets(10, 5, 0, 10);
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(10, 5, 0, 0);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(10, 10, 0, 0);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridy = 1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Data File :");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(10, 5, 0, 10);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(10, 5, 0, 0);
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 0);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Probe ID to Gene ID File :");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setPreferredSize(new Dimension(192, 95));
            this.jPanel.add((Component)this.jLabel, gridBagConstraints);
            this.jPanel.add((Component)this.getJTextField(), gridBagConstraints1);
            this.jPanel.add((Component)this.getJButton(), gridBagConstraints2);
            this.jPanel.add((Component)this.jLabel1, gridBagConstraints3);
            this.jPanel.add((Component)this.getJTextField1(), gridBagConstraints4);
            this.jPanel.add((Component)this.getJButton1(), gridBagConstraints5);
            this.jPanel.add((Component)this.getJPanel2(), gridBagConstraints6);
            this.jPanel.add((Component)this.getJPanel3(), gridBagConstraints7);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.insets = new Insets(1, 5, 0, 5);
            gridBagConstraints17.gridx = 1;
            gridBagConstraints17.gridy = 1;
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.gridheight = 1;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.insets = new Insets(1, 5, 0, 0);
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 1;
            gridBagConstraints15.fill = 0;
            gridBagConstraints15.gridheight = 1;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Status: ");
            this.jLabel2.setPreferredSize(new Dimension(45, 20));
            this.jLabel_status = new JLabel();
            this.jLabel_status.setText("");
            this.jLabel_status.setPreferredSize(new Dimension(1, 20));
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.setPreferredSize(new Dimension(0, 25));
            this.jPanel1.add((Component)this.jLabel2, gridBagConstraints15);
            this.jPanel1.add((Component)this.jLabel_status, gridBagConstraints17);
        }
        return this.jPanel1;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField();
            this.jTextField.setEditable(false);
            this.jTextField.setBackground(new Color(255, 255, 204));
        }
        return this.jTextField;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setIcon(new ImageIcon(this.getClass().getResource("/jp/or/kazusa/sakurai/util/kappatool/average/resources/folder.png")));
            this.jButton.setPreferredSize(new Dimension(22, 22));
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File tmpFile = KappaAverageMain.this.selectFile(KappaAverageMain.this.listFile, 0, "Load File");
                    KappaAverageMain.this.jTextField.setForeground(Color.black);
                    if (tmpFile != null && tmpFile.exists()) {
                        KappaAverageMain.this.listFile = tmpFile;
                        KappaAverageMain.this.jTextField.setText(KappaAverageMain.this.listFile.getName());
                    } else if (KappaAverageMain.this.listFile != null && KappaAverageMain.this.listFile.exists()) {
                        KappaAverageMain.this.jTextField.setText(KappaAverageMain.this.listFile.getName());
                    } else {
                        KappaAverageMain.this.jTextField.setForeground(Color.red);
                        KappaAverageMain.this.jTextField.setText("Select a file.");
                    }
                    KappaAverageMain.this.jTextField.setCaretPosition(0);
                }
            });
        }
        return this.jButton;
    }

    private JTextField getJTextField1() {
        if (this.jTextField1 == null) {
            this.jTextField1 = new JTextField();
            this.jTextField1.setEditable(false);
            this.jTextField1.setBackground(new Color(255, 255, 204));
        }
        return this.jTextField1;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setPreferredSize(new Dimension(22, 22));
            this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/jp/or/kazusa/sakurai/util/kappatool/average/resources/folder.png")));
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File tmpFile = KappaAverageMain.this.selectFile(KappaAverageMain.this.dataFile, 0, "Load file");
                    KappaAverageMain.this.jTextField1.setForeground(Color.black);
                    if (tmpFile != null && tmpFile.exists()) {
                        KappaAverageMain.this.dataFile = tmpFile;
                        KappaAverageMain.this.jTextField1.setText(KappaAverageMain.this.dataFile.getName());
                    } else if (KappaAverageMain.this.dataFile != null && KappaAverageMain.this.dataFile.exists()) {
                        KappaAverageMain.this.jTextField1.setText(KappaAverageMain.this.dataFile.getName());
                    } else {
                        KappaAverageMain.this.jTextField1.setForeground(Color.red);
                        KappaAverageMain.this.jTextField1.setText("Select a file.");
                    }
                    KappaAverageMain.this.jTextField1.setCaretPosition(0);
                }
            });
        }
        return this.jButton1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new FlowLayout());
            this.jPanel2.setPreferredSize(new Dimension(82, 40));
            this.jPanel2.add((Component)this.getJButton2(), null);
        }
        return this.jPanel2;
    }

    private JButton getJButton2() {
        if (this.jButton2 == null) {
            this.jButton2 = new JButton();
            this.jButton2.setText("START");
            this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/jp/or/kazusa/sakurai/util/kappatool/average/resources/goAlign.png")));
            this.jButton2.setPreferredSize(new Dimension(110, 30));
            this.jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean safe = KappaAverageMain.this.validationFiles();
                    if (safe) {
                        File tmpFile = KappaAverageMain.this.selectFile(KappaAverageMain.this.saveFile, 1, "Save file");
                        if (tmpFile == null) {
                            return;
                        }
                        KappaAverageMain.this.saveFile = tmpFile;
                        if (!KappaAverageMain.this.saveFile.getName().endsWith(".txt")) {
                            KappaAverageMain.this.saveFile = new File(String.valueOf(KappaAverageMain.this.saveFile.getPath()) + ".txt");
                        }
                        KappaAverageMain.this.doThread(Mode_DoProcess);
                    }
                }
            });
        }
        return this.jButton2;
    }

    private String getSeparator() {
        String separator = this.jComboBox.getSelectedItem().toString();
        separator = separator.equals("<tab>") ? "\t" : (separator.equals("<space>") ? " " : separator.trim());
        return separator;
    }

    private boolean validationFiles_idFormatter() {
        boolean ret = true;
        if (this.idFile == null || !this.idFile.exists()) {
            String message = "Target file not exist.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return false;
        }
        String separator = this.getSeparator();
        if (separator.equals("")) {
            String message = "Invalid Separator.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return false;
        }
        String judge = Validation.isOkFile_IdFormatFile(this.idFile, separator);
        if (!judge.equals(Validation.success)) {
            JOptionPane.showMessageDialog(this, judge, "Error", 2);
            return false;
        }
        return ret;
    }

    private boolean validationFiles() {
        boolean ret = true;
        if (this.listFile == null || !this.listFile.exists()) {
            String message = "Probe ID to Gene ID file not exist.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return false;
        }
        if (this.dataFile == null || !this.dataFile.exists()) {
            String message = "Data file not exist.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return false;
        }
        String judge = Validation.isOkFile_probeIdToGeneId(this.listFile);
        if (!judge.equals(Validation.success)) {
            JOptionPane.showMessageDialog(this, judge, "Error", 2);
            return false;
        }
        judge = Validation.isOkFile_DataFile(this.dataFile);
        if (!judge.equals(Validation.success)) {
            JOptionPane.showMessageDialog(this, judge, "Error", 2);
            return false;
        }
        return ret;
    }

    private void doIdFormat() {
        this.jButton4.setEnabled(false);
        this.jLabel_status.setText("Now Processing.");
        String separator = this.getSeparator();
        HashMap<String, HashSet<String>> data = FileIO.loadIdFile(this.idFile, separator);
        String[] probeIds = data.keySet().toArray(new String[0]);
        ArrayList<String[]> formattedData = new ArrayList<String[]>();
        int i = 0;
        while (i < probeIds.length) {
            String[] geneIds = data.get(probeIds[i]).toArray(new String[0]);
            int j = 0;
            while (j < geneIds.length) {
                String[] row = new String[]{probeIds[i], geneIds[j]};
                formattedData.add(row);
                ++j;
            }
            ++i;
        }
        FileIO.saveFormattedIdFile(this.saveFile, formattedData);
        FileIO.saveLog_FormattedIdFile(this.saveFile, data);
        this.jButton4.setEnabled(true);
        this.jLabel_status.setText("Finished.");
    }

    private void doProcess() {
        GeneData tmp;
        this.jButton2.setEnabled(false);
        this.jLabel_status.setText("Now Processing.");
        ArrayList<String[]> probeGene = FileIO.loadIdList(this.listFile);
        ArrayList<String> expNames = new ArrayList<String>();
        HashMap<String, ElementData> probeData = FileIO.loadProbeData(this.dataFile, expNames);
        HashMap<String, GeneData> geneData = new HashMap<String, GeneData>();
        int i = 0;
        while (i < probeGene.size()) {
            String probeId = probeGene.get(i)[0];
            String geneId = probeGene.get(i)[1];
            if (probeData.get(probeId) != null) {
                if (!geneData.containsKey(geneId)) {
                    tmp = new GeneData();
                    tmp.setGeneId(geneId);
                    tmp.addProbeData(probeData.get(probeId));
                    geneData.put(geneId, tmp);
                } else {
                    tmp = (GeneData)geneData.get(geneId);
                    tmp.addProbeData(probeData.get(probeId));
                    geneData.put(geneId, tmp);
                }
            }
            ++i;
        }
        String[] keys = geneData.keySet().toArray(new String[0]);
        ArrayList<GeneData> geneDataList = new ArrayList<GeneData>();
        int i2 = 0;
        while (i2 < keys.length) {
            tmp = (GeneData)geneData.get(keys[i2]);
            tmp.doCalcAverage();
            geneDataList.add(tmp);
            ++i2;
        }
        FileIO.saveResultFile(this.saveFile, expNames, geneDataList);
        this.jButton2.setEnabled(true);
        this.jLabel_status.setText("Finished.");
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
        }
        return this.jPanel3;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Calc. Average", null, this.getJPanel(), null);
            this.jTabbedPane.addTab("ID File Formatter", null, this.getJPanel4(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.insets = new Insets(3, 15, 0, 10);
            gridBagConstraints14.gridwidth = 3;
            gridBagConstraints14.anchor = 17;
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridy = 2;
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("Select or input a separator of 2nd column in the target file.");
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridwidth = 2;
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.insets = new Insets(5, 10, 0, 0);
            gridBagConstraints13.gridy = 1;
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("ID Separator :");
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.gridy = 5;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.gridwidth = 3;
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.insets = new Insets(5, 10, 0, 10);
            gridBagConstraints16.gridy = 4;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.insets = new Insets(2, 10, 0, 10);
            gridBagConstraints11.gridwidth = 3;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 3;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.insets = new Insets(10, 5, 0, 10);
            gridBagConstraints10.gridy = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(10, 5, 0, 0);
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(10, 10, 0, 0);
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.gridy = 0;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Target File : ");
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new GridBagLayout());
            this.jPanel4.add((Component)this.jLabel3, gridBagConstraints8);
            this.jPanel4.add((Component)this.getJTextField2(), gridBagConstraints9);
            this.jPanel4.add((Component)this.getJButton3(), gridBagConstraints10);
            this.jPanel4.add((Component)this.getJPanel5(), gridBagConstraints11);
            this.jPanel4.add((Component)this.getJPanel6(), gridBagConstraints16);
            this.jPanel4.add((Component)this.getJPanel7(), gridBagConstraints12);
            this.jPanel4.add((Component)this.jLabel5, gridBagConstraints13);
            this.jPanel4.add((Component)this.jLabel7, gridBagConstraints14);
        }
        return this.jPanel4;
    }

    private JTextField getJTextField2() {
        if (this.jTextField2 == null) {
            this.jTextField2 = new JTextField();
            this.jTextField2.setEditable(false);
            this.jTextField2.setBackground(new Color(255, 255, 204));
        }
        return this.jTextField2;
    }

    private JButton getJButton3() {
        if (this.jButton3 == null) {
            this.jButton3 = new JButton();
            this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/jp/or/kazusa/sakurai/util/kappatool/average/resources/folder.png")));
            this.jButton3.setPreferredSize(new Dimension(22, 22));
            this.jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File tmpFile = KappaAverageMain.this.selectFile(KappaAverageMain.this.idFile, 0, "Load File");
                    KappaAverageMain.this.jTextField2.setForeground(Color.black);
                    if (tmpFile != null && tmpFile.exists()) {
                        KappaAverageMain.this.idFile = tmpFile;
                        KappaAverageMain.this.jTextField2.setText(KappaAverageMain.this.idFile.getName());
                    } else if (KappaAverageMain.this.idFile != null && KappaAverageMain.this.idFile.exists()) {
                        KappaAverageMain.this.jTextField2.setText(KappaAverageMain.this.idFile.getName());
                    } else {
                        KappaAverageMain.this.jTextField2.setForeground(Color.red);
                        KappaAverageMain.this.jTextField2.setText("Select a file.");
                    }
                    KappaAverageMain.this.jTextField2.setCaretPosition(0);
                }
            });
        }
        return this.jButton3;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("Gene ID B ...");
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(0);
            flowLayout1.setVgap(2);
            flowLayout1.setHgap(10);
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("Probe ID A  <tab>  Gene ID A");
            this.jPanel5 = new JPanel();
            this.jPanel5.setBackground(new Color(223, 232, 238));
            this.jPanel5.setPreferredSize(new Dimension(363, 30));
            this.jPanel5.setLayout(flowLayout1);
            this.jPanel5.add((Component)this.jLabel4, null);
            this.jPanel5.add((Component)this.getJComboBox(), null);
            this.jPanel5.add((Component)this.jLabel6, null);
        }
        return this.jPanel5;
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setPreferredSize(new Dimension(80, 25));
            this.jComboBox.setFont(new Font("Dialog", 1, 12));
            this.jComboBox.setEditable(true);
            this.jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String value = KappaAverageMain.this.jComboBox.getSelectedItem().toString();
                    if (value.equals("<tab>") || value.equals("<space>")) {
                        KappaAverageMain.this.jComboBox.setEditable(false);
                    } else {
                        KappaAverageMain.this.jComboBox.setEditable(true);
                    }
                }
            });
        }
        return this.jComboBox;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new FlowLayout());
            this.jPanel6.setPreferredSize(new Dimension(44, 40));
            this.jPanel6.add((Component)this.getJButton4(), null);
        }
        return this.jPanel6;
    }

    private JButton getJButton4() {
        if (this.jButton4 == null) {
            this.jButton4 = new JButton();
            this.jButton4.setPreferredSize(new Dimension(110, 30));
            this.jButton4.setText("START");
            this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/jp/or/kazusa/sakurai/util/kappatool/average/resources/goAlign.png")));
            this.jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean safe = KappaAverageMain.this.validationFiles_idFormatter();
                    if (safe) {
                        File tmpFile = KappaAverageMain.this.selectFile(KappaAverageMain.this.saveFile, 1, "Save file");
                        if (tmpFile == null) {
                            return;
                        }
                        KappaAverageMain.this.saveFile = tmpFile;
                        if (!KappaAverageMain.this.saveFile.getName().endsWith(".txt")) {
                            KappaAverageMain.this.saveFile = new File(String.valueOf(KappaAverageMain.this.saveFile.getPath()) + ".txt");
                        }
                        KappaAverageMain.this.doThread(Mode_DoIdFormat);
                    }
                }
            });
        }
        return this.jButton4;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(new GridBagLayout());
        }
        return this.jPanel7;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                KappaAverageMain thisClass = new KappaAverageMain();
                thisClass.setDefaultCloseOperation(3);
                thisClass.setVisible(true);
            }
        });
    }

    public KappaAverageMain() {
        this.initialize();
        this.setLocationByPlatform(true);
        this.prepareComboBox_separator();
    }

    private void prepareComboBox_separator() {
        this.jComboBox.addItem(";");
        this.jComboBox.addItem("<tab>");
        this.jComboBox.addItem("<space>");
        this.jComboBox.setSelectedItem(";");
    }

    private void initialize() {
        this.setSize(423, 236);
        this.setContentPane(this.getJContentPane());
        this.setTitle("KaPPA-Average 1.0");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel1(), "South");
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
        }
        return this.jContentPane;
    }

    private File selectFile(File inFile, int mode, String title) {
        File ret = null;
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setMode(mode);
        fileDialog.setTitle(title);
        if (inFile != null && inFile.exists()) {
            fileDialog.setDirectory(inFile.getParentFile().getName());
            fileDialog.setFile(inFile.getPath());
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            ret = new File(String.valueOf(fileDialog.getDirectory()) + File.separator + fileDialog.getFile());
        }
        return ret;
    }
}

