/*
 * Decompiled with CFR 0.152.
 */
package jp.or.kazusa.sakurai.util.kappatool.average.classes;

import java.util.ArrayList;
import jp.or.kazusa.sakurai.util.kappatool.average.classes.ElementData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneData {
    private String geneId = "";
    private ArrayList<ElementData> probeData = new ArrayList();
    private ElementData averageValues = new ElementData();

    public String toStringProbeData() {
        String ret = "";
        int i = 0;
        while (i < this.probeData.size()) {
            ArrayList<Double> tmp = this.probeData.get(i).getValues();
            ret = String.valueOf(ret) + this.probeData.get(i).getId();
            ret = String.valueOf(ret) + "\t" + this.geneId;
            int j = 0;
            while (j < tmp.size()) {
                ret = String.valueOf(ret) + "\t" + tmp.get(j);
                ++j;
            }
            ret = String.valueOf(ret) + System.getProperty("line.separator");
            ++i;
        }
        return ret;
    }

    public String toStringAverageData() {
        String ret = this.geneId;
        ArrayList<Double> values = this.averageValues.getValues();
        int i = 0;
        while (i < values.size()) {
            ret = String.valueOf(ret) + "\t" + values.get(i);
            ++i;
        }
        return ret;
    }

    public void addProbeData(ElementData elementData) {
        this.probeData.add(elementData);
    }

    public void doCalcAverage() {
        if (this.probeData.size() == 0) {
            return;
        }
        if (this.probeData.size() == 1) {
            this.averageValues.setId(this.geneId);
            this.averageValues.setValues(this.probeData.get(0).getValues());
        } else {
            this.averageValues.setId(this.geneId);
            ArrayList<Double> aveValues = new ArrayList<Double>();
            int i = 0;
            while (i < this.probeData.size()) {
                ArrayList<Double> tmpValues = this.probeData.get(i).getValues();
                int j = 0;
                while (j < tmpValues.size()) {
                    if (i == 0) {
                        aveValues.add(tmpValues.get(j));
                    } else {
                        double current = aveValues.get(j);
                        aveValues.set(j, current += tmpValues.get(j).doubleValue());
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < aveValues.size()) {
                double ave = (Double)aveValues.get(i) / (double)this.probeData.size();
                aveValues.set(i, ave);
                ++i;
            }
            this.averageValues.setValues(aveValues);
        }
    }

    public String getGeneId() {
        return this.geneId;
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    public ArrayList<ElementData> getProbeData() {
        return this.probeData;
    }

    public void setProbeData(ArrayList<ElementData> probeData) {
        this.probeData = probeData;
    }

    public ElementData getAverageValues() {
        return this.averageValues;
    }

    public void setAverageValues(ElementData averageValues) {
        this.averageValues = averageValues;
    }
}

