/*
 * Decompiled with CFR 0.152.
 */
package jp.or.kazusa.sakurai.util.kappatool.average.logic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import jp.or.kazusa.sakurai.util.kappatool.average.classes.ElementData;
import jp.or.kazusa.sakurai.util.kappatool.average.classes.GeneData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileIO {
    public static void saveLog_FormattedIdFile(File saveFile, HashMap<String, HashSet<String>> data) {
        if (saveFile == null) {
            return;
        }
        if (data == null || data.size() == 0) {
            return;
        }
        String logPath = saveFile.getPath();
        logPath = String.valueOf(logPath.substring(0, logPath.length() - 4)) + ".log";
        File logFile = new File(logPath);
        PrintWriter log = null;
        try {
            try {
                log = new PrintWriter(new FileWriter(logFile));
                String[] probeIds = data.keySet().toArray(new String[0]);
                int i = 0;
                while (i < probeIds.length) {
                    int count = data.get(probeIds[i]).size();
                    if (count > 1) {
                        log.println(String.valueOf(probeIds[i]) + "\t" + count);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.close();
            }
        }
        finally {
            log.close();
        }
    }

    public static void saveFormattedIdFile(File saveFile, ArrayList<String[]> data) {
        if (saveFile == null) {
            return;
        }
        if (data == null || data.size() == 0) {
            return;
        }
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(saveFile));
                int i = 0;
                while (i < data.size()) {
                    String[] tmp = data.get(i);
                    out.println(String.valueOf(tmp[0]) + "\t" + tmp[1]);
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                out.close();
            }
        }
        finally {
            out.close();
        }
    }

    public static HashMap<String, HashSet<String>> loadIdFile(File inFile, String separator) {
        HashMap<String, HashSet<String>> ret = new HashMap<String, HashSet<String>>();
        if (inFile == null || !inFile.exists()) {
            return null;
        }
        if (separator.equals("")) {
            return null;
        }
        BufferedReader in = null;
        try {
            try {
                String s;
                in = new BufferedReader(new FileReader(inFile));
                while ((s = in.readLine()) != null) {
                    String[] line = s.split("\t");
                    if (line.length < 2) {
                        ret = null;
                        break;
                    }
                    int i = 0;
                    while (i < line.length) {
                        line[i] = line[i].trim();
                        ++i;
                    }
                    if (line[0].equals("") || line[1].equals("")) {
                        ret = null;
                        break;
                    }
                    HashSet<String> geneIds = new HashSet<String>();
                    if (separator.equals("\t")) {
                        int i2 = 1;
                        while (i2 < line.length) {
                            if (!line[i2].equals("")) {
                                geneIds.add(line[i2]);
                            }
                            ++i2;
                        }
                    } else {
                        String[] tmp = line[1].split(separator);
                        int i3 = 0;
                        while (i3 < tmp.length) {
                            tmp[i3] = tmp[i3].trim();
                            if (!tmp[i3].equals("")) {
                                geneIds.add(tmp[i3]);
                            }
                            ++i3;
                        }
                    }
                    if (ret.containsKey(line[0])) {
                        ret.get(line[0]).addAll(geneIds);
                        continue;
                    }
                    ret.put(line[0], geneIds);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static void saveResultFile(File saveFile, ArrayList<String> dataNames, ArrayList<GeneData> geneData) {
        if (dataNames == null || geneData == null) {
            return;
        }
        String logPath = saveFile.getPath();
        logPath = String.valueOf(logPath.substring(0, logPath.length() - 4)) + ".log";
        File logFile = new File(logPath);
        PrintWriter out = null;
        PrintWriter log = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(saveFile));
                int i = 0;
                while (i < dataNames.size()) {
                    if (i == 0) {
                        out.print(dataNames.get(i));
                    } else {
                        out.print("\t" + dataNames.get(i));
                    }
                    ++i;
                }
                out.println();
                i = 0;
                while (i < geneData.size()) {
                    out.println(geneData.get(i).toStringAverageData());
                    ++i;
                }
                log = new PrintWriter(new FileWriter(logFile));
                log.print("Probe ID\tGene ID");
                i = 1;
                while (i < dataNames.size()) {
                    log.print("\t" + dataNames.get(i));
                    ++i;
                }
                log.println();
                i = 0;
                while (i < geneData.size()) {
                    if (geneData.get(i).getProbeData().size() > 1) {
                        log.println("Average\t" + geneData.get(i).toStringAverageData());
                        log.print(geneData.get(i).toStringProbeData());
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                out.close();
                log.close();
            }
        }
        finally {
            out.close();
            log.close();
        }
    }

    public static HashMap<String, ElementData> loadProbeData(File inFile, ArrayList<String> dataNames) {
        if (inFile == null || !inFile.exists() || dataNames == null) {
            return null;
        }
        HashMap<String, ElementData> ret = new HashMap<String, ElementData>();
        BufferedReader in = null;
        try {
            try {
                String s;
                in = new BufferedReader(new FileReader(inFile));
                int count = 0;
                while ((s = in.readLine()) != null) {
                    String[] line = s.split("\t");
                    if (count == 0) {
                        int i = 0;
                        while (i < line.length) {
                            dataNames.add(line[i]);
                            ++i;
                        }
                        ++count;
                        continue;
                    }
                    ElementData tmp = new ElementData();
                    tmp.setId(line[0]);
                    ArrayList<Double> values = new ArrayList<Double>();
                    int i = 1;
                    while (i < line.length) {
                        values.add(Double.parseDouble(line[i]));
                        ++i;
                    }
                    tmp.setValues(values);
                    ret.put(line[0], tmp);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static ArrayList<String[]> loadIdList(File inFile) {
        if (inFile == null || !inFile.exists()) {
            return null;
        }
        ArrayList<String[]> ret = new ArrayList<String[]>();
        BufferedReader in = null;
        try {
            try {
                String s;
                in = new BufferedReader(new FileReader(inFile));
                while ((s = in.readLine()) != null) {
                    String[] line = s.split("\t");
                    ret.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }
}

