/*
 * Decompiled with CFR 0.152.
 */
package jp.or.kazusa.sakurai.util.kappatool.average.logic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class Validation {
    public static String success = "success";
    public static String Error_IOException = "File I/O Error";
    public static String Error_Exception = "Error";
    public static String Error_NullString = "Invalid String";
    public static String Error_InvalidColumnNumber = "Invalid Column Number";
    public static String Error_FileNotFound = "File Not Found";
    public static String Error_FileNotDefined = "File Not Defined";
    public static String Error_NumberFormatException = "Invalid Data";

    public static String isOkFile_IdFormatFile(File inFile, String separator) {
        String ret = success;
        if (inFile == null) {
            return Error_FileNotDefined;
        }
        if (!inFile.exists()) {
            return Error_FileNotFound;
        }
        BufferedReader in = null;
        int count = 0;
        try {
            try {
                String s;
                in = new BufferedReader(new FileReader(inFile));
                while ((s = in.readLine()) != null) {
                    ++count;
                    String[] line = s.split("\t");
                    if (line[0].trim().equals("")) {
                        ret = String.valueOf(Error_NullString) + ". (ID File: row " + count + ")";
                        break;
                    }
                    if (line[1].trim().equals("")) {
                        ret = String.valueOf(Error_NullString) + ". (ID File: row " + count + ")";
                        break;
                    }
                    line[1].split(separator);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                ret = Error_IOException;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ret = String.valueOf(Error_Exception) + ". (ID File: row " + count + ")";
                try {
                    in.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * Loose catch block
     */
    public static String isOkFile_DataFile(File inFile) {
        String ret = success;
        if (inFile == null) {
            return Error_FileNotDefined;
        }
        if (!inFile.exists()) {
            return Error_FileNotFound;
        }
        BufferedReader in = null;
        int count = 0;
        try {
            try {
                String s;
                in = new BufferedReader(new FileReader(inFile));
                int colNum = 0;
                while ((s = in.readLine()) != null) {
                    int i;
                    String[] line = s.split("\t");
                    if (++count == 1) {
                        colNum = line.length;
                        i = 1;
                        while (i < line.length) {
                            if (line[i].trim().equals("")) {
                                ret = String.valueOf(Error_NullString) + ". (Data File: Exp. name in col. " + i + ")";
                                break;
                            }
                            ++i;
                        }
                        if (ret.equals(success)) continue;
                        break;
                    }
                    if (line.length != colNum) {
                        ret = String.valueOf(Error_InvalidColumnNumber) + ". (Data File: row " + count + ")";
                        break;
                    }
                    i = 1;
                    while (i < line.length) {
                        double d = Double.parseDouble(line[i]);
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                ret = Error_IOException;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                ret = String.valueOf(Error_NumberFormatException) + ". (Data File: row " + count + ")";
                try {
                    in.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ret = String.valueOf(Error_Exception) + ". (Data File: row " + count + ")";
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static String isOkFile_probeIdToGeneId(File inFile) {
        String ret = success;
        if (inFile == null) {
            return Error_FileNotDefined;
        }
        if (!inFile.exists()) {
            return Error_FileNotFound;
        }
        BufferedReader in = null;
        int count = 0;
        try {
            try {
                String s;
                in = new BufferedReader(new FileReader(inFile));
                while ((s = in.readLine()) != null) {
                    ++count;
                    String[] line = s.split("\t");
                    if (line.length != 2) {
                        ret = String.valueOf(Error_InvalidColumnNumber) + ". (Probe to Gene File: row " + count + ")";
                    } else if (line[0].trim().equals("")) {
                        ret = String.valueOf(Error_NullString) + ". (Probe to Gene File: row " + count + ")";
                    } else {
                        if (!line[1].trim().equals("")) continue;
                        ret = String.valueOf(Error_NullString) + ". (Probe to Gene File: row " + count + ")";
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                ret = Error_IOException;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ret = String.valueOf(Error_Exception) + ". (Probe to Gene File: row " + count + ")";
                try {
                    in.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }
}

